/*
 * Decompiled with CFR 0.152.
 */
package com.mygdx.game;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.mygdx.game.Bot;
import com.mygdx.game.Counter;
import com.mygdx.game.ObjectId;
import com.mygdx.game.Weapon;
import com.mygdx.game.Workspace;

public abstract class Entity
extends Group {
    public ObjectId id;
    public Rectangle LeftBounds;
    public Rectangle RightBounds;
    public Rectangle TopBounds;
    public Rectangle BottomBounds;
    public Workspace workspace;
    public float angle = 0.0f;
    protected float health;
    protected float maxHealth;
    public Weapon gun;
    public float speed;
    public Vector2 facing;
    float deltaX = 0.0f;
    float deltaY = 0.0f;
    public Rectangle[] bounds;
    public Rectangle Bound;
    public boolean alive = true;
    public float oldX;
    public float oldY;
    public Counter oldTimer;

    Entity(float x, float y, float w, float h, float health, ObjectId id, Workspace ws) {
        this.setBounds(x, y, w, h);
        this.health = health;
        this.maxHealth = health;
        this.id = id;
        this.workspace = ws;
        this.facing = new Vector2(0.0f, 0.0f);
        this.bounds = new Rectangle[4];
        this.oldTimer = new Counter(30, true);
    }

    public Rectangle getBound() {
        return new Rectangle(this.getX(), this.getY(), this.getWidth() * 1.5f, this.getHeight() * 1.5f);
    }

    public void calculateBounds() {
        this.Bound = new Rectangle(this.getX(), this.getY(), this.getWidth(), this.getHeight());
        this.TopBounds = new Rectangle(this.getX(), this.getY() + this.getHeight() / 8.0f * 7.0f, this.getWidth(), this.getHeight() / 5.0f);
        this.BottomBounds = new Rectangle(this.getX(), this.getY(), this.getWidth(), this.getHeight() / 5.0f);
        this.LeftBounds = new Rectangle(this.getX() - this.getWidth() / 6.0f, this.getY() + this.getHeight() / 8.0f + this.getHeight() / 10.0f, this.getWidth() / 3.0f, this.getHeight() - this.getHeight() / 5.0f * 2.0f);
        this.RightBounds = new Rectangle(this.getX() + this.getWidth() - this.getWidth() / 6.0f, this.getY() + this.getHeight() / 8.0f + this.getHeight() / 10.0f, this.getWidth() / 3.0f, this.getHeight() - this.getHeight() / 5.0f * 2.0f);
        this.bounds[0] = this.LeftBounds;
        this.bounds[1] = this.RightBounds;
        this.bounds[2] = this.TopBounds;
        this.bounds[3] = this.BottomBounds;
    }

    protected boolean gotPixelinBounds(Rectangle bounds, float r, float g, float b, Pixmap dataMap, int id) {
        int x = (int)bounds.x;
        while ((float)x < bounds.x + bounds.width) {
            int y = (int)bounds.y;
            while ((float)y < bounds.y + bounds.height) {
                int pixel = dataMap.getPixel(x, dataMap.getHeight() - y);
                Color color = new Color(pixel);
                float r1 = color.r;
                float g1 = color.g;
                float b1 = color.b;
                if (r1 == r && g1 == g & b1 == b) {
                    return true;
                }
                y += 3;
            }
            x += (int)bounds.width;
        }
        return false;
    }

    public void felloCollision() {
        int i = 0;
        while (i < this.workspace.getActors().size) {
            Actor a = (Actor)this.workspace.getActors().get(i);
            if (a instanceof Bot) {
                Bot ent = (Bot)a;
                ent.calculateBounds();
                if (!((Object)((Object)ent)).equals((Object)this)) {
                    Vector2 off = this.getOffset(ent.getX() + ent.getWidth() / 2.0f, ent.getY() + ent.getHeight() / 2.0f);
                    while (this.getMagnitude(off) * 2.0f < this.getMagnitude(new Vector2(this.getWidth(), this.getHeight()))) {
                        off = this.getOffset(ent.getX() + ent.getWidth() / 2.0f, ent.getY() + ent.getHeight() / 2.0f);
                        Vector2 unit = this.getUnitVector(off);
                        this.setX(this.getX() - unit.x);
                        this.setY(this.getY() - unit.y);
                    }
                }
            }
            ++i;
        }
    }

    public void act(float delta) {
        if (this.health <= 0.0f) {
            this.alive = false;
        }
        this.oldTimer.update();
        if (this.oldTimer.current % 1 == 0) {
            this.oldX = this.getX();
            this.oldY = this.getY();
        }
        super.act(delta);
    }

    protected void FitBounds() {
        this.calculateBounds();
        boolean offset = true;
        if (this.getId() != ObjectId.Player) {
            this.felloCollision();
        }
        while (this.gotPixelinBounds(this.LeftBounds, 0.78431374f, 0.39215687f, 0.78431374f, this.workspace.currentMap.dataMap, 0)) {
            this.setX(this.getX() + (float)offset);
            this.calculateBounds();
        }
        while (this.gotPixelinBounds(this.RightBounds, 0.78431374f, 0.39215687f, 0.78431374f, this.workspace.currentMap.dataMap, 1)) {
            this.setX(this.getX() - (float)offset);
            this.calculateBounds();
        }
        while (this.gotPixelinBounds(this.TopBounds, 0.78431374f, 0.39215687f, 0.78431374f, this.workspace.currentMap.dataMap, 2)) {
            this.setY(this.getY() - (float)offset);
            this.calculateBounds();
        }
        while (this.gotPixelinBounds(this.BottomBounds, 0.78431374f, 0.39215687f, 0.78431374f, this.workspace.currentMap.dataMap, 3)) {
            this.setY(this.getY() + (float)offset);
            this.calculateBounds();
        }
    }

    public void drawBounds(ShapeRenderer shape) {
        shape.begin(ShapeRenderer.ShapeType.Line);
        shape.setColor(Color.PINK);
        shape.rect(this.getX(), this.getY() + this.getHeight() / 8.0f * 6.0f, this.getWidth(), this.getHeight() / 5.0f);
        shape.rect(this.getX(), this.getY(), this.getWidth(), this.getHeight() / 5.0f);
        shape.rect(this.getX() - this.getWidth() / 6.0f, this.getY() + this.getHeight() / 8.0f + this.getHeight() / 10.0f, this.getWidth() / 3.0f, this.getHeight() - this.getHeight() / 5.0f * 2.0f);
        shape.rect(this.getX() + this.getWidth() - this.getWidth() / 6.0f, this.getY() + this.getHeight() / 8.0f + this.getHeight() / 10.0f, this.getWidth() / 3.0f, this.getHeight() - this.getHeight() / 5.0f * 2.0f);
        shape.end();
    }

    public float getHealth() {
        return this.health;
    }

    public void setHealth(float health) {
        this.health = health;
    }

    public float getMaxHealth() {
        return this.maxHealth;
    }

    public void setMaxHealth(float maxHealth) {
        this.maxHealth = maxHealth;
    }

    public Vector2 getOffset(float x, float y) {
        return new Vector2(x - (this.getX() + this.getWidth() / 2.0f), y - (this.getY() + this.getHeight() / 2.0f));
    }

    public Vector2 getOffset(Vector2 v2) {
        return this.getOffset(v2.x, v2.y);
    }

    public float getMagnitude(Vector2 v2) {
        float mag = (float)Math.sqrt(v2.x * v2.x + v2.y * v2.y);
        return mag;
    }

    public Vector2 getUnitVector(Vector2 v2) {
        float mag = this.getMagnitude(v2);
        return new Vector2(v2.x / mag, v2.y / mag);
    }

    public ObjectId getId() {
        return this.id;
    }
}

