/*
 * Decompiled with CFR 0.152.
 */
package com.mygdx.game;

import Weapons.Pistol;
import Weapons.SMG;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.actions.RotateToAction;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Touchpad;
import com.mygdx.game.Counter;
import com.mygdx.game.Effector;
import com.mygdx.game.Entity;
import com.mygdx.game.ObjectId;
import com.mygdx.game.Workspace;

public class Player
extends Entity {
    private ShapeRenderer shape = new ShapeRenderer();
    private Texture tex;
    public static int playerCount = 0;
    public int playerId;
    Workspace workspace;
    private boolean enableDrawBounds = false;
    private int canFit = 0;
    private Counter clock;
    private Image Sprite;
    private Counter purchaseCounter;
    public Touchpad onScreenController;
    public Effector nearest;
    private float currentAngle;

    Player(float x, float y, float w, float h, ObjectId id, Workspace ws) {
        super(x, y, w, h, 100.0f, id, ws);
        this.workspace = ws;
        this.calculateBounds();
        this.currentAngle = 0.0f;
        this.playerId = ++playerCount;
        this.speed = 8.0f;
        this.tex = new Texture(Gdx.files.internal("player.png"));
        this.Sprite = new Image(){

            public void draw(Batch batch, float parentAlpha) {
                batch.draw(Player.this.tex, this.getX(), this.getY(), this.getWidth() / 2.0f, this.getHeight() / 2.0f, this.getWidth(), this.getHeight(), this.getScaleX(), this.getScaleY(), this.getRotation(), 0, 0, Player.this.tex.getWidth(), Player.this.tex.getHeight(), false, false);
                super.draw(batch, parentAlpha);
            }
        };
        this.clock = new Counter(100, true);
        this.purchaseCounter = new Counter(100, false);
        this.addActor((Actor)this.Sprite);
        this.Sprite.setBounds(0.0f, 0.0f, this.getWidth(), this.getHeight());
        this.setOriginX(this.getWidth() / 2.0f);
        this.setOriginY(this.getHeight() / 2.0f);
        this.gun = Gdx.input.isKeyPressed(43) ? new SMG(this) : new Pistol(this);
        this.addActor((Actor)this.gun);
    }

    public void draw(Batch batch, float parentAlpha) {
        batch.end();
        this.shape.setProjectionMatrix(batch.getProjectionMatrix());
        this.shape.setTransformMatrix(batch.getTransformMatrix());
        this.shape.begin(ShapeRenderer.ShapeType.Filled);
        this.shape.setColor(Color.BLUE);
        this.shape.end();
        if (this.enableDrawBounds) {
            this.drawBounds(this.shape);
        }
        batch.begin();
        super.draw(batch, parentAlpha);
    }

    @Override
    public void act(float delta) {
        this.setX(this.getX() + this.deltaX);
        this.setY(this.getY() + this.deltaY);
        if (this.canFit >= 30) {
            this.FitBounds();
            if (this.canFit == 30) {
                this.setPosition(this.workspace.currentMap.GetPlayerCoords().x, this.workspace.currentMap.GetPlayerCoords().y);
                ++this.canFit;
            }
        } else {
            ++this.canFit;
        }
        this.movement();
        if (Gdx.input.isKeyPressed(40)) {
            this.health = 0.0f;
        }
        this.clock.update();
        if (this.health != this.maxHealth && this.clock.current % 300 % 20 == 0) {
            this.health += 1.0f;
        }
        this.health = this.health > this.maxHealth ? this.maxHealth : this.health;
        float prox = 100000.0f;
        this.nearest = null;
        int i = 0;
        while (i < this.workspace.game.Effectors.size) {
            Effector effector = (Effector)this.workspace.game.Effectors.get(i);
            Actor ef = (Actor)effector;
            Vector2 offset = this.getOffset(ef.getX(), ef.getY());
            float mag = this.getMagnitude(offset);
            if (mag < prox && mag < 150.0f) {
                prox = mag;
                this.nearest = effector;
            }
            ++i;
        }
        if (Gdx.input.isKeyPressed(35) && this.purchaseCounter.current == 0) {
            this.purchaseCounter.update();
            if (this.nearest != null) {
                this.nearest.Action(this);
            }
        }
        if (this.purchaseCounter.current != 0) {
            this.purchaseCounter.update();
            if (this.purchaseCounter.current >= 100) {
                this.purchaseCounter.current = 0;
            }
        }
        super.act(delta);
    }

    public void movement() {
        this.deltaX = 0.0f;
        this.deltaY = 0.0f;
        if (this.onScreenController == null) {
            return;
        }
        if (Gdx.input.isKeyPressed(51) || Gdx.input.isKeyPressed(19) || (double)this.onScreenController.getKnobPercentY() > 0.4) {
            this.deltaY = this.speed;
        }
        if (Gdx.input.isKeyPressed(47) || Gdx.input.isKeyPressed(20) || (double)this.onScreenController.getKnobPercentY() < -0.4) {
            this.deltaY = -this.speed;
        }
        if (Gdx.input.isKeyPressed(32) || Gdx.input.isKeyPressed(22) || (double)this.onScreenController.getKnobPercentX() > 0.4) {
            this.deltaX = this.speed;
        }
        if (Gdx.input.isKeyPressed(29) || Gdx.input.isKeyPressed(21) || (double)this.onScreenController.getKnobPercentX() < -0.4) {
            this.deltaX = -this.speed;
        }
        this.enableDrawBounds = Gdx.input.isKeyPressed(31);
        if (this.deltaX != 0.0f && this.deltaY != 0.0f) {
            this.deltaX = (float)((double)this.speed / Math.sqrt(2.0) * (double)(this.deltaX > 0.0f ? 1 : -1));
            this.deltaY = (float)((double)this.speed / Math.sqrt(2.0) * (double)(this.deltaY > 0.0f ? 1 : -1));
        }
        Vector2 uiMpos = this.workspace.game.ui.screenToStageCoordinates(new Vector2((float)Gdx.input.getX(), (float)Gdx.input.getY()));
        if (uiMpos.x < this.onScreenController.getWidth() && uiMpos.y < this.onScreenController.getHeight()) {
            return;
        }
        Vector2 worldMpos = this.workspace.screenToStageCoordinates(new Vector2((float)Gdx.input.getX(), (float)Gdx.input.getY()));
        Vector2 mpos = this.getOffset(worldMpos);
        mpos = this.getUnitVector(mpos);
        this.facing.x = mpos.x;
        this.facing.y = mpos.y;
        this.angle = -mpos.angle(new Vector2(0.0f, 1.0f));
        float diff = this.angle - this.currentAngle;
        this.currentAngle = this.angle - diff * 0.8f;
        if (Gdx.input.isButtonPressed(0)) {
            this.gun.Fire(this.facing);
        }
        if (diff > 180.0f) {
            this.currentAngle = 180.0f;
        } else if (diff < -180.0f) {
            this.currentAngle = -180.0f;
        }
        RotateToAction rotateAction = new RotateToAction();
        rotateAction.setRotation(this.currentAngle);
        this.addAction((Action)rotateAction);
    }
}

