/*
 * Decompiled with CFR 0.152.
 */
package com.mygdx.game;

import com.badlogic.gdx.graphics.Camera;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.utils.viewport.StretchViewport;
import com.badlogic.gdx.utils.viewport.Viewport;
import com.mygdx.game.Game_;
import com.mygdx.game.Game_Map;
import com.mygdx.game.ObjectId;
import com.mygdx.game.Player;
import com.mygdx.game.TextOverlay;
import specFX.Stains;

public class Workspace
extends Stage {
    public Game_ game;
    public Game_Map currentMap;
    public Player player1;
    public TextOverlay worldText;
    public Stains blood;

    public Workspace(Game_ game) {
        super((Viewport)new StretchViewport(1280.0f, 720.0f));
        this.game = game;
    }

    public void assetLoaded() {
        this.currentMap = new Game_Map("Map2", this);
        this.currentMap.graphMap();
        this.addActor((Actor)this.currentMap);
        this.blood = new Stains(this);
        this.worldText = new TextOverlay();
        this.player1 = new Player(this.currentMap.GetPlayerCoords().x, this.currentMap.GetPlayerCoords().y, 70.0f, 70.0f, ObjectId.Player, this);
        this.addActor(this.blood);
        this.addActor((Actor)this.player1);
        this.addActor(this.worldText);
        this.addActor(new HealthHud());
    }

    public void act(float delta) {
        Camera cam = this.getCamera();
        cam.translate((this.player1.getX() - cam.position.x) * 0.2f, (this.player1.getY() + 150.0f - cam.position.y) * 0.2f, 0.0f);
        if (!this.player1.alive) {
            this.game.ui.End();
        }
        super.act(delta);
    }

    private class HealthHud
    extends Actor {
        private HealthHud() {
        }

        public void draw(Batch batch, float parentAlpha) {
            super.draw(batch, parentAlpha);
            this.setZIndex(0);
            float ratio = Workspace.this.player1.health / Workspace.this.player1.getMaxHealth();
            batch.setColor(new Color(1.0f / ratio, ratio, ratio, 1.0f));
        }
    }
}

